//   Listing 9-2
import java.util.Scanner;

public class Listing9_2
{
   public static void main(String[] args)
   {
      final int SIZE = 6;                 // Rozmiar tablicy
      int[] testScores = new int[SIZE];   // Tablica, w której zapiszemy wyniki ze sprawdzianów
      
      // Pobieramy wyniki ze sprawdzianów
      getTestScores(testScores);
   
      // Sortujemy wyniki ze sprawdzianów
      bubbleSort(testScores);
   
      // Wyświetlamy wyniki ze sprawdzianów
      System.out.println("Oto wyniki ze sprawdzianów");
      System.out.println("uporządkowane od najniższego do najwyższego:");
      showTestScores(testScores);
   }
   
   // Metoda getTestScores prosi użytkownika
   // o wprowadzenie wyników ze sprawdzianów i zapisuje je w tablicy
   // przekazanej jako argument
   public static void getTestScores(int[] array)
   {
      // Zmienna licznikowa
      int index;
      
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Pobieramy wyniki ze sprawdzianów
      for (index = 0; index < array.length; index++)
      {
         System.out.print("Wprowadź wynik ze sprawdzianu numer " +(index + 1) + ": ");
        array[index] =  keyboard.nextInt();
      }
   }
   
   /**
      Metoda bubbleSort implementuje algorytm sortowania bąbelkowego elementów
      tablicy.
      Zwróć uwagę na następujące rzeczy:
      (1) Nie musimy przekazywać do metody rozmiaru tablicy,
          ponieważ w języku Java tablica ma pole length, które informuje o jej rozmiarze
      (2) Nie ma osobnej metody do zamiany elementów;
          to dlatego, że w języku Java nie można przekazywać argumentu przez referencję;
          zamiana elementów odbywa się w tej metodzie
   */
   
   public static void bubbleSort(int[] array)
   {
      int maxElement;  // Indeks ostatniego elementu tablicy, który ma zostać porównany
      int index;       // Indeks elementu, który mamy zamiar porównać
      int temp;        // Zmienna używana podczas zamiany elementów
      
      // Pętla zewnętrzna ustawia zmienną maxElement na wartość równą 
      // ostatniemu indeksowi tablicy, który ma zostać porównany w danym
      // przejściu. Na samym początku zmienna maxElement będzie równa
      // indeksowi ostatniego elementu tablicy. Podczas każdej kolejnej iteracji
      // będzie ona dekrementowana o 1
      for (maxElement = array.length - 1; maxElement >= 0; maxElement--)
      {
         // Pętla wewnętrzna śledzi tablicę i porównuje
         // sąsiadujące ze sobą elementy. Porównywane są 
         // elementy o indeksach od 0 do maxElement.
         // Jeżeli kolejność elementów jest nieprawidłowa,
         // zostają one zamienione miejscami
         for (index = 0; index <= maxElement - 1; index++)
         {
            // Porównujemy element z elementem sąsiadującym
            if (array[index] > array[index + 1])
            {
               // Zamieniamy miejscami dwa elementy
               temp = array[index];
               array[index] = array[index + 1];
               array[index + 1] = temp;
            }
         }
      }   
   }
   
   // Metoda showTestScores wyświetla zawartość
   // tablicy przekazanej jako argument
   public static void showTestScores(int[] array)
   {
      // Zmienna licznikowa
      int index;
      
      // Wyświetlamy wyniki ze sprawdzianów
      for (index = 0; index < array.length; index++)
      {
         System.out.println(array[index]);
      }
   }

}